# Implementing Dijkstra Algorithm
## Medium
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given a weighted, undirected and connected graph of <strong>V</strong> vertices and an adjacency list adj where adj[i] is a list of lists containing two integers where the<strong> first </strong>integer of each list <strong>j</strong>&nbsp;denotes there is <strong>edge</strong> between i and j&nbsp;,&nbsp;second integers corresponds to the <strong>weight</strong> of that&nbsp;&nbsp;edge .&nbsp;You are given the source vertex <strong>S</strong> and You to&nbsp;Find the shortest distance of all the vertex's from the source vertex <strong>S</strong>.&nbsp;You have to return a list of integers denoting shortest distance between <strong>each node</strong> and Source vertex<strong> S</strong>.</span><br>
&nbsp;</p>

<p><span style="font-size:18px"><strong>Note: </strong>The Graph doesn't contain any negative weight cycle.</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Example 1:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:</strong></span>
<span style="font-size:18px"><strong>V </strong>= 2
<strong>adj [] </strong>=<strong> </strong>{{{1, 9}}, {{0, 9}}}
<strong>S </strong>= 0</span>
<span style="font-size:18px"><strong>Output:</strong>
0 9
<strong>Explanation</strong>:
</span><img alt="" src="data:image/png;base64,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">
<span style="font-size:18px">The source vertex is 0. Hence, the shortest 
distance of node 0 is 0 and the shortest 
distance from node 1 is 9.</span>
</pre>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Example 2:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:
V </strong>= 3, <strong>E</strong> = 3
<strong>adj</strong> = {{{1, 1}, {2, 6}}, {{2, 3}, {0, 1}}, {{1, 3}, {0, 6}}}</span>
<span style="font-size:18px"><strong>S </strong>= 2</span>
<span style="font-size:18px"><strong>Output:</strong>
4 3 0
<strong>Explanation</strong>:
</span><img alt="" src="data:image/png;base64,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">
<span style="font-size:18px">For nodes 2 to 0, we can follow the path-
2-1-0. This has a distance of 1+3 = 4,
whereas the path 2-0 has a distance of 6. So,
the Shortest path from 2 to 0 is 4.
The shortest distance from 0 to 1 is 1 .</span>
</pre>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Your Task:</strong><br>
You don't need to read input or print anything. Your task is to complete the function&nbsp;<strong>dijkstra()</strong>&nbsp;</span> <span style="font-size:18px">which takes the number of vertices V<strong> </strong>and<strong>&nbsp;</strong>an adjacency list adj as input parameters&nbsp;and Source vertex S returns a list of integers, where ith integer denotes the shortest distance of the ith node from the Source node. </span> <span style="font-size:18px">Here adj[i] contains a list of lists containing two integers where the first integer j denotes that there is an edge between i and j and the second integer w denotes that the weight between edge i and j is w.</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Expected Time Complexity:</strong>&nbsp;O(V<sup>2</sup>).<br>
<strong>Expected Auxiliary Space:</strong>&nbsp;O(V<sup>2</sup>).</span></p>

<p>&nbsp;</p>

<div><span style="font-size:18px"><strong>Constraints:</strong><br>
1 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> V </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> 1000<br>
0 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> adj[i][j] </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> 1000</span></div>

<div><span style="font-size:18px">1 ≤&nbsp;adj.size()&nbsp;≤ [ (V*(V - 1)) / 2 ]<br>
0 </span> <span style="font-size:18px">≤</span> <span style="font-size:18px"> S &lt; V</span></div>
</div>